/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Stack;
import processing.core.PApplet;
import processing.core.PGraphics;

public class sketch_aug30a
extends PApplet {
    final int NUM_BALLS = 600;
    final int GOAL_FRAME_RATE = 60;
    ArrayList<Ball> myBalls = new ArrayList();
    final int MIN_BUFFER_FRAMES = 60;
    Queue<PGraphics> FrameBuffer = new LinkedList<PGraphics>();
    final float PROXIMITY_TO_SPHERE = 0.66f;
    final int SIZE_TO_SPHERE = 10;
    final int RENDER_WIDTH = 640;
    final int RENDER_HEIGHT = 480;
    int interlaceLines = 0;
    boolean monochromeMode = false;
    float startTime;
    float lastDrawTime;
    PGraphics grid;

    public void setup() {
        this.size(640, 480, "processing.core.PGraphics3D");
        this.noStroke();
        int n = 0;
        while (n < 600) {
            this.myBalls.add(new Ball());
            ++n;
        }
        GridPainter gridPainter = new GridPainter();
        gridPainter.flip();
        this.grid = gridPainter.getFrame();
        this.startTime = this.millis();
    }

    public void draw() {
        float f = this.millis();
        if (this.myBalls.size() > 0 && f - this.lastDrawTime > 60.0f) {
            this.myBalls.remove(this.myBalls.size() - 1);
        }
        if (f - this.startTime > 30000.0f) {
            this.monochromeMode = true;
            this.interlaceLines = 2;
        }
        this.lastDrawTime = f;
        this.background(0);
        PGraphics pGraphics = this.RenderFrame();
        if (this.interlaceLines > 0) {
            this.Interlace(pGraphics);
        }
        this.image(pGraphics, 0.0f, 0.0f, pGraphics.width, pGraphics.height);
        if (f - this.startTime < 10000.0f) {
            this.blend(this.grid, 0, 0, this.grid.width, this.grid.height, 0, 0, this.grid.width, this.grid.height, 128);
        } else if (!this.monochromeMode) {
            this.blend(this.grid, 0, 0, this.grid.width, this.grid.height, 0, 0, this.grid.width, this.grid.height, 512);
        }
    }

    public void Interlace(PGraphics pGraphics) {
        pGraphics.loadPixels();
        int n = 0;
        while (n < pGraphics.height * pGraphics.width) {
            int n2 = n;
            while (n2 < n + this.interlaceLines * pGraphics.width) {
                if (n2 >= pGraphics.width * pGraphics.height) break;
                pGraphics.pixels[n2] = this.color(0, 0, 0);
                ++n2;
            }
            n += 2 * this.interlaceLines * pGraphics.width;
        }
        pGraphics.updatePixels();
    }

    public PGraphics RenderFrame() {
        PGraphics pGraphics = this.createGraphics(640, 480, "processing.core.PGraphics3D");
        pGraphics.beginDraw();
        pGraphics.noStroke();
        pGraphics.lights();
        pGraphics.translate(this.width / 2, this.height / 2);
        pGraphics.scale(0.5f);
        pGraphics.translate(-this.width / 2, -this.height / 2);
        int n = 0;
        while (n < this.myBalls.size()) {
            Ball ball = this.myBalls.get(n);
            ball.Draw(pGraphics);
            ball.Move();
            ++n;
        }
        pGraphics.endDraw();
        return pGraphics;
    }

    public static void main(String[] stringArray) {
        PApplet.main(new String[]{"--bgcolor=#F0F0F0", "sketch_aug30a"});
    }

    class Ball {
        final float STARTING_Y;
        final int MIN_BALL_SIZE = 5;
        final int MAX_BALL_SIZE = 15;
        private int mySize;
        private Vector myVector;
        private Vertex myVertex;
        private int myColor;
        private boolean hasBeenMonochromized;

        public Ball() {
            this.STARTING_Y = sketch_aug30a.this.height + 300;
            this.MIN_BALL_SIZE = 5;
            this.MAX_BALL_SIZE = 15;
            this.hasBeenMonochromized = false;
            this.initRandom();
        }

        public void Draw(PGraphics pGraphics) {
            if (sketch_aug30a.this.monochromeMode && !this.hasBeenMonochromized) {
                this.ColorToMonochrome();
            }
            pGraphics.fill(this.myColor);
            this.myVertex.TranslateOn(pGraphics);
            if (this.mySize >= 10 && this.myVertex.z >= (float)sketch_aug30a.this.width * 0.66f) {
                pGraphics.sphere(this.mySize);
            } else {
                pGraphics.ellipse(0.0f, 0.0f, this.mySize, this.mySize);
            }
            this.myVertex.TranslateOff(pGraphics);
        }

        public void Move() {
            this.myVertex.Move(this.myVector);
            if (this.myVertex.y < (float)(-sketch_aug30a.this.height)) {
                this.initRandom();
            }
        }

        private void initRandom() {
            this.mySize = (int)sketch_aug30a.this.random(5.0f, 15.0f);
            this.myVector = new Vector(0.0f, sketch_aug30a.this.random(-5.0f, -1.0f), 0.0f);
            this.myVertex = new Vertex(sketch_aug30a.this.random(0.0f, sketch_aug30a.this.width), this.STARTING_Y, sketch_aug30a.this.random(0.0f, sketch_aug30a.this.width));
            this.myColor = sketch_aug30a.this.monochromeMode ? sketch_aug30a.this.color(0, (int)sketch_aug30a.this.random(32.0f, 192.0f), 0) : sketch_aug30a.this.color((int)sketch_aug30a.this.random(32.0f, 192.0f), (int)sketch_aug30a.this.random(32.0f, 192.0f), (int)sketch_aug30a.this.random(32.0f, 192.0f));
        }

        public void ColorToMonochrome() {
            this.myColor = sketch_aug30a.this.color(0.0f, sketch_aug30a.this.green(this.myColor), 0.0f);
            this.hasBeenMonochromized = true;
        }
    }

    public class Coord {
        public float x;
        public float y;
        public float z;

        public Coord() {
            this.z = 0.0f;
            this.y = 0.0f;
            this.x = 0.0f;
        }

        public Coord(float f, float f2, float f3) {
            this.x = f;
            this.y = f2;
            this.z = f3;
        }

        public Coord(Coord coord) {
            this.x = coord.x;
            this.y = coord.y;
            this.z = coord.z;
        }
    }

    class GridPainter {
        ArrayList<Hexagon> hexagons = new ArrayList();
        float myAngle = -90.0f;
        private PGraphics frame;

        public GridPainter() {
            this.setup();
            this.render();
        }

        public void setup() {
            this.BuildHexagonGrid();
        }

        public PGraphics getFrame() {
            return this.frame;
        }

        public void render() {
            this.frame = sketch_aug30a.this.createGraphics(sketch_aug30a.this.width, sketch_aug30a.this.height, "processing.core.PGraphics3D");
            this.frame.beginDraw();
            this.frame.noFill();
            this.frame.background(0);
            this.SetScale(this.frame);
            this.frame.rotateX(sketch_aug30a.radians(this.myAngle));
            int n = 0;
            while (n < this.hexagons.size()) {
                Hexagon hexagon = this.hexagons.get(n);
                hexagon.Draw(this.frame);
                ++n;
            }
            this.frame.rotateX(-sketch_aug30a.radians(this.myAngle));
            this.frame.endDraw();
        }

        public void flip() {
            int n;
            Colour[] colourArray;
            this.frame.loadPixels();
            Stack<Colour[]> stack = new Stack<Colour[]>();
            int n2 = 0;
            while (n2 < this.frame.width * this.frame.height) {
                colourArray = new Colour[this.frame.width];
                n = 0;
                int n3 = n2;
                while (n3 < n2 + this.frame.width) {
                    colourArray[n++] = new Colour(sketch_aug30a.this.red(this.frame.pixels[n3]), sketch_aug30a.this.green(this.frame.pixels[n3]), sketch_aug30a.this.blue(this.frame.pixels[n3]));
                    ++n3;
                }
                stack.push(colourArray);
                n2 += this.frame.width;
            }
            n2 = 0;
            while (!stack.isEmpty()) {
                colourArray = (Colour[])stack.pop();
                n = 0;
                while (n < colourArray.length) {
                    Colour colour = colourArray[n];
                    this.frame.pixels[n2++] = sketch_aug30a.this.color(colour.r, colour.g, colour.b);
                    ++n;
                }
            }
            this.frame.updatePixels();
        }

        public void SetScale(PGraphics pGraphics) {
            pGraphics.translate(sketch_aug30a.this.width / 2, sketch_aug30a.this.height / 2);
            pGraphics.scale(5.0f);
            pGraphics.translate(-sketch_aug30a.this.width / 2, -sketch_aug30a.this.height / 2);
        }

        /*
         * Unable to fully structure code
         */
        public void BuildHexagonGrid() {
            var1_1 = new Vertex();
            var2_2 = false;
            var3_3 = 0.0f;
            var4_4 = 0.0f;
            var5_5 = 255;
            ** GOTO lbl21
            {
                var6_6 = new Hexagon(var1_1);
                var6_6.setBrightness(var5_5);
                this.hexagons.add(var6_6);
                var3_3 = var6_6.getWidth();
                var4_4 = var6_6.getHeight();
                var1_1.x += var3_3;
                do {
                    if (var1_1.x < (float)sketch_aug30a.this.width) continue block0;
                    var2_2 = var2_2 == false;
                    var1_1.x = var2_2 != false ? var3_3 / 2.0f : 0.0f;
                    var1_1.y += var4_4 - 15.0f;
                    if ((var5_5 -= 7) >= 0) continue;
                    var5_5 = 0;
lbl21:
                    // 3 sources

                } while (var1_1.y < (float)(sketch_aug30a.this.height * 3));
            }
        }

        private class Colour {
            public int r;
            public int g;
            public int b;

            public Colour(float f, float f2, float f3) {
                this.r = (int)f;
                this.g = (int)f2;
                this.b = (int)f3;
            }
        }

        class Hexagon {
            private Vertex[] myPoints = new Vertex[6];
            private int myBrightness = 255;

            public Hexagon(Vertex vertex) {
                this.init(vertex);
            }

            private void init(Vertex vertex) {
                this.myPoints[0] = new Vertex(vertex);
                this.myPoints[1] = new Vertex(vertex.x + 15.0f, vertex.y + 15.0f, vertex.z);
                this.myPoints[2] = new Vertex(vertex.x + 15.0f, vertex.y + 30.0f, vertex.z);
                this.myPoints[3] = new Vertex(vertex.x, vertex.y + 45.0f, vertex.z);
                this.myPoints[4] = new Vertex(vertex.x - 15.0f, vertex.y + 30.0f, vertex.z);
                this.myPoints[5] = new Vertex(vertex.x - 15.0f, vertex.y + 15.0f, vertex.z);
            }

            public void setBrightness(int n) {
                this.myBrightness = n;
            }

            public float getWidth() {
                return this.myPoints[1].x - this.myPoints[5].x;
            }

            public float getHeight() {
                return this.myPoints[3].y - this.myPoints[0].y;
            }

            public void Draw(PGraphics pGraphics) {
                pGraphics.stroke(this.myBrightness);
                pGraphics.beginShape();
                int n = 0;
                while (n < 6) {
                    pGraphics.vertex(this.myPoints[n].x, this.myPoints[n].y, this.myPoints[n].z);
                    ++n;
                }
                pGraphics.vertex(this.myPoints[0].x, this.myPoints[0].y, this.myPoints[0].z);
                pGraphics.endShape();
            }
        }
    }

    public class Vector
    extends Coord {
        public Vector() {
        }

        public Vector(float f, float f2, float f3) {
            super(f, f2, f3);
        }
    }

    public class Vertex
    extends Coord {
        public Vertex() {
        }

        public Vertex(Vertex vertex) {
            super(vertex);
        }

        public Vertex(float f, float f2, float f3) {
            super(f, f2, f3);
        }

        public void TranslateOn(PGraphics pGraphics) {
            pGraphics.translate(this.x, this.y, this.z);
        }

        public void TranslateOff(PGraphics pGraphics) {
            pGraphics.translate(-this.x, -this.y, -this.z);
        }

        public void Move(Vector vector) {
            this.x += vector.x;
            this.y += vector.y;
            this.z += vector.z;
        }
    }
}

