/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioInput;
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import ddf.minim.analysis.FFT;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;

public class SmokeRings
extends PApplet {
    ArrayList<Ring> rings;
    PGraphics lastFrame;
    int feedbackOffset;
    final int BAND_RESOLUTION = 5;
    final float NORMAL_SCALE = 1.02f;
    float myScale = 0.99f;
    final float SCALE_PUSH = 0.005f;
    final float SCALE_FALLBACK = 0.001f;
    float lastDrawTime = 0.0f;
    float highestPeak = 0.0f;
    float MIN_AMP_TO_DRAW = 8.5f;
    final float AMP_CHANGE = 0.1f;
    Minim minim;
    AudioPlayer player;
    AudioInput input;
    FFT fft;
    boolean loadSuccessful = false;

    public void setup() {
        this.size(640, 480, "processing.core.PGraphics3D");
        this.smooth();
        this.noFill();
        this.feedbackOffset = this.width;
        this.minim = new Minim((PApplet)this);
        try {
            this.player = this.minim.loadFile("song.mp3");
            this.input = this.minim.getLineIn();
            this.player.play();
            this.loadSuccessful = true;
            this.fft = new FFT(this.player.bufferSize(), this.player.sampleRate());
            int n = this.fft.specSize() / 5;
            this.rings = new ArrayList(n);
            int n2 = 0;
            while (n2 < n) {
                this.rings.add(new Ring());
                ++n2;
            }
        }
        catch (Exception exception) {}
    }

    public void stop() {
        this.player.close();
        this.input.close();
        this.minim.stop();
        super.stop();
    }

    public void keyPressed() {
        if (this.key == '\uffff') {
            if (this.keyCode == 38) {
                this.MIN_AMP_TO_DRAW += 0.1f;
            } else if (this.keyCode == 40) {
                this.MIN_AMP_TO_DRAW -= 0.1f;
            } else if (this.keyCode == 37) {
                this.myScale += 0.024999999f;
            }
        }
        if (this.MIN_AMP_TO_DRAW < 0.0f) {
            this.MIN_AMP_TO_DRAW = 0.0f;
        }
        if (this.MIN_AMP_TO_DRAW > 200.0f) {
            this.MIN_AMP_TO_DRAW = 200.0f;
        }
    }

    public void draw() {
        float f;
        if (!this.loadSuccessful) {
            this.background(0);
            this.fill(255);
            PFont pFont = this.createFont("Comic Sans", 32.0f);
            this.textFont(pFont);
            this.textMode(256);
            this.text("Please place desired song in app directory.\nCall it 'song.mp3'.\nThen run this application again.", 0.0f, this.height / 2);
            return;
        }
        float f2 = this.millis();
        if (this.lastDrawTime > 0.0f && f2 - this.lastDrawTime > 30.0f) {
            this.lastDrawTime = f2;
            return;
        }
        this.lastDrawTime = f2;
        this.background(0);
        this.SetScale();
        if (this.lastFrame != null) {
            this.image((PImage)this.lastFrame, 0.0f, 0.0f, this.width, this.height);
        }
        if ((f = this.RenderRings()) > this.highestPeak) {
            this.highestPeak = f;
            this.myScale += 0.005f;
        } else {
            this.highestPeak -= 5.0f;
        }
        if (f < 1.0f && this.myScale > 0.001f) {
            this.myScale -= 0.001f;
        }
        this.lastFrame = this.Feedback(this.g);
    }

    public void SetScale() {
        this.translate(this.width / 2, this.height / 2);
        this.scale(this.myScale);
        if (this.myScale > 1.02f) {
            this.myScale -= 0.001f;
        }
        this.translate(-this.width / 2, -this.height / 2);
    }

    public float RenderRings() {
        float f = 0.0f;
        int n = 0;
        while (n < this.rings.size()) {
            Ring ring = this.rings.get(n);
            float f2 = this.GetBandPeak(n);
            f += f2;
            ring.Draw(f2);
            ++n;
        }
        return f;
    }

    public float GetBandPeak(int n) {
        this.fft.forward(this.player.mix);
        float f = 0.0f;
        int n2 = n;
        while (n2 < n + 5) {
            float f2 = SmokeRings.pow((float)(n2 + 1), (float)1.1f) / 20.0f;
            float f3 = this.fft.getBand(n2);
            if (f3 > 0.0f && (f3 += f2) > f) {
                f = f3;
            }
            ++n2;
        }
        return f;
    }

    public PGraphics Feedback(PGraphics pGraphics) {
        PGraphics pGraphics2 = this.createGraphics(pGraphics.width, pGraphics.height, "processing.core.PGraphics2D");
        pGraphics.loadPixels();
        pGraphics2.loadPixels();
        int n = this.feedbackOffset;
        while (n < pGraphics.width * pGraphics.height) {
            pGraphics2.pixels[n] = pGraphics.pixels[n - this.feedbackOffset];
            ++n;
        }
        pGraphics2.updatePixels();
        return pGraphics2;
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#000000", "SmokeRings"});
    }

    class Colour {
        public float r;
        public float g;
        public float b;

        public Colour() {
            this.r = SmokeRings.this.random(32.0f, 64.0f);
            this.g = SmokeRings.this.random(32.0f, 64.0f);
            this.b = SmokeRings.this.random(32.0f, 64.0f);
        }
    }

    class Ring {
        private Vertex myVertex;
        private float myRadius;
        private Colour myColor;

        public Ring() {
            this.myColor = new Colour();
            float f = 100.0f;
            this.myVertex = new Vertex(SmokeRings.this.random(f, (float)SmokeRings.this.width - f), SmokeRings.this.random(f, (float)SmokeRings.this.height - f), SmokeRings.this.random(0.0f, 25.0f));
            this.myRadius = 1.0f;
        }

        public void Draw(float f) {
            boolean bl = false;
            if (f >= SmokeRings.this.MIN_AMP_TO_DRAW) {
                bl = true;
            }
            float f2 = this.myRadius + f + this.myVertex.z;
            float f3 = 1.0f + f / 15.0f;
            if (bl) {
                SmokeRings.this.stroke(SmokeRings.min((float)(this.myColor.r * f3), (float)255.0f), SmokeRings.min((float)(this.myColor.g * f3), (float)255.0f), SmokeRings.min((float)(this.myColor.b * f3), (float)255.0f));
            } else {
                SmokeRings.this.stroke(20.0f, 20.0f, 20.0f);
            }
            SmokeRings.this.ellipse(this.myVertex.x, this.myVertex.y, f2, f2);
        }
    }

    class Vertex {
        public float x;
        public float y;
        public float z;

        public Vertex() {
            this.z = 0.0f;
            this.y = 0.0f;
            this.x = 0.0f;
        }

        public Vertex(float f, float f2, float f3) {
            this.x = f;
            this.y = f2;
            this.z = f3;
        }
    }
}

